/* -----------------------------------------------------------------------
   This script allows to animate deformations using a ramp function.
----------------------------------------------------------------------- */

// Find visible view

For k In {1 : PostProcessing.NbViews}
    If(View[k-1].Visible)
       mode = k;
       k = PostProcessing.NbViews;
    EndIf
EndFor 

nstep  = 21;
ncycle = 20;

// Function to display animation

Function Animate

   n = mode - 1;
   VectorType  = View[n].VectorType;
   ScaleFactor = View[n].DisplacementFactor;

   View[n].VectorType = 5;

   nstep  = GetValue("Number of time steps per cycle", nstep);
   ncycle = GetValue("Number of cycles", ncycle);
   SF     = GetValue("Scale Factor", ScaleFactor);

   For c In {1 : ncycle}
       For frame In {1 : nstep} 
           View[n].DisplacementFactor = SF * frame/nstep;
           Draw;
       EndFor
       Sleep 0.5;
   EndFor

   View[n].DisplacementFactor = ScaleFactor;
   View[n].VectorType         = VectorType;

Return

// Animation of visible view

Call Animate;

// Repeat animation, start new animation, or end

For loop In {1 : 2}

   next = mode + 1;
   If(next > PostProcessing.NbViews)
      next = 1;
   EndIf
   next = GetValue("Number of next mode to animate
   (Enter -1 to repeat current mode or -2 to exit)",
          next);
   
   If(next == -2)
      loop = 2;
   EndIf     

   If(next == -1)
      Call Animate;
      loop = 1;
   EndIf

   If(next > -1)
      View[n].Visible = 0;
      mode = next;
      If(mode > PostProcessing.NbViews)
         mode = 1;
      EndIf
      n = mode - 1;
      Printf("n = %f", n);
      View[n].Visible = 1;
      Call Animate;     
      loop = 1;
   EndIf

EndFor
