/* -----------------------------------------------------------------------
   This script allows to animate mode shapes.
----------------------------------------------------------------------- */

// Find visible view

mode = 1;

For k In {1 : PostProcessing.NbViews}
    If(View[k-1].Visible)
       mode = k;
       k = PostProcessing.NbViews;
    EndIf
EndFor 

View[mode-1].Visible = 1;

nstep  = 21;
ncycle = 20;
sleep  = 0.05;

// Repeat animation, start new animation, or end

For loop In {1 : 2}

   // Animation

   n = mode - 1;
   VectorType  = View[n].VectorType;
   ScaleFactor = View[n].DisplacementFactor;

   View[n].VectorType = 5;

   nstep  = GetValue("Number of time steps per cycle", nstep);
   ncycle = GetValue("Number of cycles", ncycle);
   SF     = GetValue("Scale Factor", ScaleFactor);
   sleep  = GetValue("Sleep Factor", sleep);

   For c In {1 : ncycle}
       For frame In {1 : nstep} 
           View[n].DisplacementFactor = SF * Sin(2 * Pi * frame/nstep);
           Draw;
           Sleep sleep;
       EndFor
   EndFor

   View[n].DisplacementFactor = ScaleFactor;
   View[n].VectorType         = VectorType;
   
   // Look what's next

   next = mode + 1;
   If(next > PostProcessing.NbViews)
      next = 1;
   EndIf
   next = GetValue("Number of next mode to animate
   (Enter -1 to repeat current mode or -2 to exit)",
          next);
   
   // End Animation

   If(next == -2)
      loop = 2;
   EndIf     

   // Repeat same mode

   If(next == -1)
      loop = 1;
   EndIf

   // Continue with next mode

   If(next > -1)
      View[n].Visible = 0;
      mode = next;
      If(mode > PostProcessing.NbViews)
         mode = 1;
      EndIf
      n = mode - 1;
      View[n].Visible = 1;
      loop = 1;
   EndIf

EndFor
