/* ------------------------------------------------------------------------
   This script scales the displacements such that the largest value
   equals the displacement factor times the length of the model
   diagonal.
------------------------------------------------------------------------ */

RelScale = GetValue("Relative displacement scale factor", 0.05);

For k In {0 : PostProcessing.NbViews - 1}
    Diagonal = (View[k].MaxX - View[k].MinX)^2;
    Diagonal = Diagonal + (View[k].MaxY - View[k].MinY)^2; 
    Diagonal = Diagonal + (View[k].MaxZ - View[k].MinZ)^2; 
    Diagonal = Sqrt(Diagonal);
    View[k].DisplacementFactor = RelScale * Diagonal / View[k].Max;
    View[k].VectorType = 5;
EndFor 
