function install()

# This function installs Mefisto by adding the path to the
# Mefisto functions to file .octaverc in the home directory.
#
# -------------------------------------------------------------------

# Get path to Mefisto source directory

##  fname = [mfilename(), ".m"];
##  spath = file_in_loadpath(fname);
##  ln    = length(spath) - length(fname);
##  spath = [spath(1 : ln), "src"];

  spath = [pwd, filesep(), "src"];

# Go to home directory

  cd

# Create or modifiy .octaverc

  fid = fopen(".octaverc", "at");
  fprintf(fid, "\n# Mefisto 2.7\n");
  fprintf(fid, "addpath(\'%s\');\n", spath);
  fclose(fid);

# Make path available for current session

  addpath(spath);

# Report message

  msg = sprintf(" Installation successful\n\n Path %s added to\n file %s\n",
                spath, [pwd, "/.octaverc"]);
  if (isguirunning)
     msgbox(msg, "Information");
  else
     printf("%s\n", msg);
  end

# Show Mefisto info

  mefisto

end
