function confmat = mfs_confmat(config)

# usage: confmat = mfs_confmat(config)
#
# Input  config         Structure with configuration data
#
# Output confmat(:, :)  Matrix with configuration parameters
#                       (columns correspond to configurations)
#
# The function builds the matrix of configuration parameters. The
# downwash matrix multiplied with the matrix of configuration
# parameters gives the right-hand side in a static analysis.
#
# ---------------------------------------------------------------------

# Check parameters

  if (nargin != 1 || nargout != 1)
     print_usage();
  end

# Initialize

  mrow    = 3 + config.ncntrl;
  ncol    = config.nconf;
  confmat = zeros(mrow, ncol, "double");

  confmat(1, :) = ones(1, ncol);   % Camber
  confmat(2, :) = config.alpha;
  if (isfield(config, "beta"))
     confmat(3, :) = config.beta;
  end

  if (config.ncntrl)
     n = 4;
     for [angle, cntnam] = config.cntls
         confmat(n++, :) = angle;
     end
  end

end
