function camber = mfs_naca4(digits)

# usage: camber = mfs_naca4(digits)
#
# Input  digits   Digits 1 and 2 of airfoil definition
#
# Output camber   Piecewise polynomial defining camber
#
# --------------------------------------------------------------------

# Check arguments

  if (nargin != 1 || nargout != 1)
     print_usage();
  end

# Define camber (cf. http://airfoiltools.com/airfoil/naca4digit)

   M = floor(digits / 10) / 100;
   P = mod(digits, 10) / 10;

   b   = [0, P, 1];

   c1 = M / P^2; c2 = M / (1 - P)^2;
   c  = [ -c1, 2 * P * c1, 0;
          -c2, 2 * P * c2, (1 - 2 * P) * c2 ];
   c(2, :) = polyaffine(c(2, :), [-P, 1]);

   camber = mkpp(b, c);

end



