function [cmp, rc] = mfs_newx(msg, model, options)

# usage: [cmp, rc] = mfs_newx(msg, model, options)
#
# Input  msg     File handle of message file
#        model   Structure with model data
#        options Structure with options
#
# Output cmp     Structure with component data
#                (0 if errors occurred)
#        rc      Return code: 0 = no errors
#                             1 = errors
#
# The function initializes a new component of type aero. The only method
# currently supported is the vortex lattice method (subtype vlm).
#
# -----------------------------------------------------------------------------

  cmp = struct();

# Check arguments

  if (nargin != 3 || nargout != 2)
     print_usage();
  end

# Initialize

  rc  = 1;

# Model subtype

  if (isfield(model, "subtype"))
     switch model.subtype
     case "vlm"
        [cmp, rc] = mfs_new_vlm(msg, model, options);
     otherwise
        fprintf(msg, "*E* Unknown model subtype %s\n", model.subtype);
        return;
     end
  else
     fprintf(msg, "*E* Model subtype not defined\n");
     return;
  end

end
