function mfs_prt_complex(fid, ids, data, kred, title);

# usage: mfs_prt_complex(fid, ids, data, kred, title)
#
# Input  fid          File handle
#        ids(:)       Row identifiers
#        data(:, :)   Scalar data
#        kred(:)      Reduced frequencies
#        title        Title
#
# The function prints complex scalar data that depend on the reduced
# frequency. Each column contains the data of one reduced frequency.
#
# ---------------------------------------------------------------------

  ncl = 2;   % Number of columns per line

# Check arguments

  if (nargin != 5 || nargout != 0)
     print_usage();
  end

# Header and dimensions

  fprintf(fid, "%s\n", title); 
  [mr, nc] = size(data);

# Output the data

  nleft = nc;
  n1    =  1;

  while (nleft > 0)

     nact = min(nleft, ncl);
     n2   = n1 + nact - 1;

     fprintf(fid, "\n      k  ");
     for n = n1 : n2
         fprintf(fid, "           %6.4f           ", kred(n));
     end
   
     fprintf(fid, "\n");

     for m = 1 : mr
         fprintf(fid, "\n  %5.0d: ", m);
         for n = n1 : n2
             fprintf(fid, " (%11.4e, %11.4e) ", 
                     real(data(m, n)), imag(data(m, n)));
         end
     end

     fprintf(fid, "\n");

     n1 = n2 + 1;
     nleft -= ncl;

  end

  fprintf(fid, "\n");

end
