function mfs_prt_scalar(fid, ids, s, title);

# usage: mfs_prt_scalar(fid, ids, s, title)
#
# Input  fid       File handle
#        ids(:)    Row identifiers
#        s(:, :)   Scalar data
#        title     Title
#
# The function prints scalar data.
#
# ---------------------------------------------------------------------

  ncl = 6;   % Number of columns per line

# Check arguments

  if (nargin != 4 || nargout != 0)
     print_usage();
  end

# Header and dimensions

  fprintf(fid, "%s\n", title); 
  [mr, nc] = size(s);

# Output the data

  nleft = nc;
  n1    =  1;

  while (nleft > 0)

     nact = min(nleft, ncl);
     n2   = n1 + nact - 1;

     fprintf(fid, "\n  Config.");
     for n = n1 : n2
         fprintf(fid, "     %3d      ", n);
     end
   
     fprintf(fid, "\n");

     for m = 1 : mr
         fprintf(fid, "\n  %5.0d: ", m);
         for n = n1 : n2
             fprintf(fid, "%12.4e  ", s(m, n));
         end
     end

     fprintf(fid, "\n");

     n1 = n2 + 1;
     nleft -= ncl;

  end

  fprintf(fid, "\n");

end
