function mfs_prt_trimparam(fid, type, tpnames, tpval, isangle,
                           qdyn, cnames, qr)

# usage: mfs_prt_trimparam(fid, type, tpnames, tpval, isangle, qdyn, cnames, qr)
#
# Input  fid       File handle
#        type      Trim type
#        tpnames   Cell array with trim parameter names
#        tpval     Array with parameter values
#        isangle   Array indicating if parameter is an angle (0 or 1)
#        qdyn      Array with dynamic pressure
#        cnames    Cell array with configuration names
#        qr(6, :)  Rigid body parameters
#
# The function prints the values of the trim parameters.
#
# ---------------------------------------------------------------------

  ncl = 4;          % Number of configurations per line

  rbpnames = {"tx", "ty", "tz", "rx", "ry", "rz"};

# Check arguments

  if (nargin < 7 || nargin > 8 || nargout != 0)
     print_usage();
  end

# Header and dimensions

  fprintf(fid, "Results of %s trim analysis", type);
  fprintf(fid, " (Angles are in degrees)\n");
  [np, nconf] = size(tpval);

# Convert angles to degrees

  r2d = 180 / pi;
  ix  = find(isangle); 
  tpval(ix, :) = tpval(ix, :) * r2d;

# Output trim variables

  nleft = nconf;
  n1    =     1;

  while (nleft > 0)

      nact = min(nleft, ncl);
      n2   = n1 + nact - 1;

      fprintf(fid, "\n");

#     Configuration names

      for n = n1 : n2
          fprintf(fid, "  Configuration %3d: %s\n", n, cnames{n});
      end

      fprintf(fid, "\n  Configuration    ");
      for n = n1 : n2
          fprintf(fid, "           %3d", n);
      end

      fprintf(fid, "\n");
      fprintf(fid, "\n  qdyn                 = ");
      for n = n1 : n2
          fprintf(fid, "%12.4e  ", qdyn(n));
      end
      fprintf(fid, "\n");

      for p = 1 : np
          fprintf(fid, "  %-20s = ", tpnames{p});
          for n = n1 : n2
              fprintf(fid, "%12.4e  ", tpval(p, n));
          end
          fprintf(fid, "\n");
      end

      if (nargin == 8)
          qr(4 : 6, :) = qr(4 : 6, :) * r2d;
          fprintf(fid, "\n");
          for p = 1 : 6
              fprintf(fid, "  %-20s = ", rbpnames{p});
              for n = n1 : n2
                  fprintf(fid, "%12.4e  ", qr(p, n));
              end
              fprintf(fid, "\n");
          end
      end

      n1 = n2 + 1;
      nleft -= ncl;

  end

end
