function [cmp, rc] = mfs_statrespx(cmp)

# usage: [cmp, rc] = mfs_statrespx(cmp)
#
# Input  cmp     Structure with component data
#
# Output cmp     Structure with component data
#        rc      Return code: 0 = no errors
#                             1 = errors
#
# The function computes the the statric response of an aerodynamic
# component.
#
# Methods supported: vortex-lattice method
#
# --------------------------------------------------------------------

  warning("off", "Octave:broadcast");

# Check arguments

  if (nargin != 1 || nargout != 2)
     print_usage();
  end

# Initialize

  rc = 0;

# Check if configurations have been defined

  if (! cmp.config.nconf)
     printf("*E** mfs_statresp: Definition of configurations missing\n");
     rc = 1;
     return;
  end

# Build right-hand side

  dw      = mfs_vlmdw(cmp.panels, cmp.controls, cmp.config);
  confmat = mfs_confmat(cmp.config);
  rhs     = dw * confmat;

# Build matrix of influence coefficients

  symy = isfield(cmp, "symy");
  if (symy)
     ys = cmp.symy;
  else
     ys = 0;
  end

  C = mfs_vlmmat(cmp.ls, cmp.panels, symy, ys);

# Solve for G

  G = C \ rhs;

# Store the results

  statresp = struct("nconf", cmp.config.nconf, "G", G);

  cmp.statresp = statresp;

  warning("on", "Octave:broadcast");

end
