function area = mfs_tzarea(P1, P2, P3, P4, nvec)

# usage: area = mfs_tzarea(P1, P2, P3, P4)
#
# Input  P1(3) to P4(3)   Coordinates of the corner points
#        nvec(3)          Normal vector of trapezoid
#
# Output area             Area
#
# The function computes the area of a trapezoid whose parallel edges
# are alligned with the x-axis.
#
#          P1 ---- P3
#          |       |
#          P2 ---- P4
#
# --------------------------------------------------------------------

  h = (P3(2) - P1(2)) * nvec(3) - (P3(3) - P1(3)) * nvec(2);
  d = 0.5 * (P2(1) - P1(1) + P4(1) - P3(1));
  area = d * h;

end
