function mfs_printc(fid, cmp, class, items)

# usage: mfs_printc(fid, cmp, class, items)
#
# Input  fid       File handle
#        cmp       Structure with component
#        class     Output data class
#        items{}   List of items to be printed
#
# The function prints the results of an aeroelastic component.
#
# The items supported depend on the class:
#
#  class = flutter
#        curves    Curve data
#
# ---------------------------------------------------------------------

# Copyright (c) 2018 by Johannes Wandinger

# Check arguments

  if (nargin < 4)
     print_usage();
  end

# Process parameters

  switch class

  case "flutter"

     if (! isfield(cmp, "flutter"))
        printf("*W* mfs_print: there are no items of class \"flutter\"\n");
        return;
     end

     for k = 1 : length(items)
         switch items{k}
         case "curves"
             mfs_prt_flutter_curves(fid, cmp.flutter);
         otherwise
            printf("*W* mfs_print: unknown item \"%s\"\n", items{k});
         end
     end

  otherwise

     printf("*W* mfs_print: unknwon class \"%s\"\n", class);

  end     % Class

end
