function mfs_prt_flutter_curves(fid, flutter)

# usage: mfs_prt_flutter_curves(fid, flutter)
# Input  fid       File handle
#        flutter   Structure with flutter results
#
# The function writes the data of the flutter curves to the output file.
#
# ---------------------------------------------------------------------

# Copyright (c) 2017 by Johannes Wandinger

# Check arguments

  if (nargin != 2)
     print_usage();
  end

# Header

  fprintf(fid, "Results of flutter analysis, %s-method\n", flutter.method);

# Results

  switch flutter.method

  case "k"

     for m = 1 : flutter.nofmod

        fprintf(fid, "\n Flutter mode %2d\n\n", m); 
        fprintf(fid, " Point:      k           v           g           f      \n");
        fprintf(fid, " -------------------------------------------------------\n");

        for n = 1 : flutter.nofpnt
            fprintf(fid, "  %4d:  %10.6f  %10.4e  %10.3e  %10.5f\n",
                    n, flutter.kred(n), flutter.v(m, n), flutter.g(m, n),
                    flutter.f(m, n));
        end

     end

  case "pk"

     for m = 1 : flutter.nofmod

        fprintf(fid, "\n Flutter mode %2d\n\n", flutter.modno(m)); 
        fprintf(fid, " Point:      v           k           a           f      \n");
        fprintf(fid, " -------------------------------------------------------\n");

        for n = 1 : flutter.nofpnt
            fprintf(fid, "  %4d:  %10.4e  %10.6f  %10.3e  %10.5f\n",
                    n, flutter.v(n), flutter.kred(m, n), flutter.a(m, n),
                    flutter.f(m, n));
        end

  end

end

