function cmp = mfs_splinesx(cmp)

# usage: cmp = mfs_splinesx(cmp)
#
# Input  cmp    Structure with component data
#
# Output cmp    Structure with component data
#               (Spline matrices added)
#
# The function computes the spline matrices of an aeroelastic
# component.
#
# Currently, only the torsion-bending spline is implemented.
#
# --------------------------------------------------------------------

# Check arguments

  if (nargin != 1 || nargout != 1)
     print_usage();
  end

# Initialize

  ng       = cmp.solid.dofs.ndofg;
  mxdofpnt = cmp.solid.dofs.mxdofpnt;

  for n = 1 : cmp.splines.nofspl
      nh(n) = 2 * cmp.splines.data{n}.nbreaks;
  end

  nhtot = sum(nh);

  cref = cmp.aero.cref;

  cmp.splines.Shg = sparse(nhtot, ng);
  cmp.splines.Svh = sparse(cmp.aero.panels.nofpan, nhtot);
  cmp.splines.Snh = sparse(3 * cmp.aero.nodes.nofnod, nhtot);
  cmp.splines.D1h = sparse(cmp.aero.panels.nofpan, nhtot);
  cmp.splines.D2h = sparse(cmp.aero.panels.nofpan, nhtot);

# Loop over the splines

  rx1 = 1;
  for n = 1 : cmp.splines.nofspl
      rx2 = rx1 + nh(n) - 1;
      pid = cmp.splines.data{n}.pid;
      lastwarn("");
      [Shg, Svh, Snh, D1h, D2h] = ...
          mfs_spline_tb(cmp.splines.data{n}, cmp.aero.panels,
                        cmp.aero.nodes, ng,  mxdofpnt, cref);
      msg = lastwarn();
      if (length(msg))
         printf("Reduce number of spline segments of spline %4.0d\n",
                 cmp.splines.ids(n));
      end
      cmp.splines.Shg(rx1 : rx2, :) = Shg;
      cmp.splines.Svh(pid, rx1 : rx2) = Svh;
      cmp.splines.Snh(:, rx1 : rx2) = Snh;
      cmp.splines.D1h(pid, rx1 : rx2) = D1h;
      if (cref)
         cmp.splines.D2h(pid, rx1 : rx2) = D2h;
      end
      rx1 = rx2 + 1;
  end

end
