function cmpa = mfs_trf_disp(cmpa, cmps, Shg, Snh)

# usage: cmpa = mfs_trf_disp(cmpa, cmps, Shg, Snh)
#
# Input  cmpa    Structure with data of aerodynamic component
#        cmps    Structure with results of solid component
#        Shg     Matrix relating solid displacements to spline
#                coefficients
#        Snh     Matrix relating spline coefficients to displacements
#                at panel corner nodes
#
# Output cmpa    Structure with data of aerodynamic component
#
# Structure disp containing the displacements at the panel corner
# nodes is added to stucture statresp of component cmpa.
#
# --------------------------------------------------------------------

# Check arguments

  if (nargin != 4 || nargout != 1)
     print_usage();
  end

# Define configurations

  cmpa.config = struct("nconf", cmps.nofldc);
  names = cell(cmpa.config.nconf);
  for n = 1 : cmpa.config.nconf
      names{n} = sprintf("LC %3d", n);
  end
  cmpa.config.names = names;

# Get displacements

  cmpa.statresp.nconf = cmps.nofldc;
  cmpa.statresp.disp  = Snh * (Shg * cmps.disp);

end
