function cmps = mfs_trf_loads(cmps, cmpa, class, Shg, Svh)

# usage: cmps = mfs_trf_loads(cmps, cmpa, Shg, Svh)
#
# Input  cmps    Structure with data of solid component
#        cmpa    Structure with data of aerodynamic component
#        class   Structure with data of result class
#        Shg     Matrix relating solid displacements to spline
#                coefficients
#        Svh     Matrix relating spline coefficients to displacements
#                at vortex points
#
# Output cmps    Structure with data of solid component
#
# Structure load containing the aerodynamic loads on the solid
# component is added to cmps.
#
# --------------------------------------------------------------------

# Check arguments

  if (nargin != 5 || nargout != 1)
     print_usage();
  end

# Aerodynamic data

  panres = class.panres;
  nofpan = panres.nofpan;
  nconf  = class.nconf;
  nvec   = cmpa.panels.nvec(2 : 3, :);

  f  = panres.f(2 : 3, :, :);

  fa = zeros(nofpan, nconf);
  for n = 1 : nconf
      fa(:, n) = dot(nvec, f(:, :, n));
  end

# Loads on solid
  
  load.nofldc = nconf;
  
  infbit = bitset(0, 1);
  load.infldc = repmat(infbit, 1, nconf);

  load.f = Shg' * (Svh' * fa);

  mxdofpnt = cmps.dofs.mxdofpnt;
  nofnod   = cmps.nodes.nofnod;
  type     = 0;

  pnt   = struct("type", type);

  for l = 1 : nconf
      fr         = reshape(load.f(:, l), mxdofpnt, nofnod)';
      [id, jc]   = find(fr);
      id         = unique(id);
      pnt        = struct("type", type, "nofnod", length(id),
                          "id", id, "d", fr(id, :));
      pnt        = mfs_resnodedata(pnt, cmps.nodes);
      point(l) = pnt;
  end

  load.point = point;

  cmps.load = load;
   
end
