function cmpa = mfs_trf_modes(cmpa, modes, rigmod, Shg, Snh)

# usage: cmpa = mfs_trf_modes(cmpa, modes, rigmod, Shg, Snh)
#
# Input  cmpa    Structure with data of aerodynamic component
#        modes   Structure with normal modes of solid component
#        rigmod  Number of rigid body modes
#        Shg     Matrix relating solid displacements to spline
#                coefficients
#        Snh     Matrix relating spline coefficients to displacements
#                at panel corner nodes
#
# Output cmpa    Structure with data of aerodynamic component
#
# Structure modes containing the displacements at the panel corner
# nodes is added to component cmpa.
#
# --------------------------------------------------------------------

# Check arguments

  if (nargin != 5 || nargout != 1)
     print_usage();
  end

# Get normal modes

  cmpa.modes.nofmod = modes.nofmod;
  cmpa.modes.rigmod = rigmod;
  cmpa.modes.omega  = modes.omega;
  cmpa.modes.freq   = modes.freq;
  cmpa.modes.disp   = Snh * (Shg * modes.disp);

end
