function [S1X, S2X] = mfs_vlmv2x(panels, pancols, SvX, cref)

# usage: [S1X, S2X] = mfs_vlmv2x(panels, pancols, SvX, cref)
#
# Input  panels       Structure with panel data
#        pancols      Structure with panel column data
#        SvX(:, :)    Transformation matrix from modal forces
#                     to panel forces
#        cref         Reference chord length
#
# Output S1X(:, :)    Matrix S1X to compute modal forces from vortex
#                     strengths
#        S2X(:, :)    Matrix S2X to compute modal forces from vortex
#                     strengths
#
# The total matrix is SX = S1X + i * k * S2X.
#
# --------------------------------------------------------------------

# S1X: same as steady

  S1X = 2 * panels.width .* SvX';

# S2X: Summation matrix

  s = 4 / cref;
  S = sparse(panels.nofpan, panels.nofpan);

  panids = pancols.panids;
  for n = 1 : pancols.npcol
      pids = panids{n};
      for m = 2 : length(pids)
          S(pids(m), pids(1 : m - 1)) = s;
      endfor
  endfor

  S2X = (panels.area .* SvX') * S;

endfunction
