function mfs_exportx(fid, cmp)

# usage: mfs_exportx(fid, cmp)
#
# Input  fid       File identifier of output file
#        cmp       Structure with component
#
# The function exports a solid component to an m-file that can be
# read by CIMNE MAT-fem (see http://www.cimne.com/mat-fem/).
#
# ------------------------------------------------------------------------

# Material properties and thickness
# (All elements must have same material and thickness)

  mat  = cmp.elements.elem(1).mat;
  geom = cmp.elements.elem(1).geom;

  fprintf(fid, "%% Material Properties\n%%\n");
  fprintf(fid, "  young  =  %16.9e ;\n", mat.E);
  fprintf(fid, "  poiss  =  %16.9e ;\n", mat.ny);
  fprintf(fid, "  denss  =  %16.9e ;\n", mat.rho);
  fprintf(fid, "  thick  =  %16.9e ;\n", geom.t);

# Coordinates

  fprintf(fid, "%%\n%% Coordinates\n%%\n");
  fprintf(fid, "global coordinates\n");
  fprintf(fid, "coordinates = [\n");

  for n = 1 : cmp.nodes.nofnod - 1
      fprintf(fid, " %16.9e   ,  %16.9e   ,  %16.9e  ;\n",
              cmp.nodes.coor(n, :));
  end 
  fprintf(fid, " %16.9e   ,  %16.9e   ,  %16.9e  ] ;\n",
              cmp.nodes.coor(end, :));

# Elements

  fprintf(fid, "%%\n%% Elements\n%%\n");
  fprintf(fid, "global elements\n");
  fprintf(fid, "elements = [\n");

  for n = 1 : cmp.elements.nofelt - 1
      fprintf(fid, "  %5.0d  ,  %5.0d  ,  %5.0d  ,  %5.0d  ;\n",
              cmp.elements.elem(n).nodes);
  end
  fprintf(fid, "  %5.0d  ,  %5.0d  ,  %5.0d  ,  %5.0d  ] ;\n",
          cmp.elements.elem(end).nodes);

# Constraints

  fprintf(fid, "%%\n%% Fixed Nodes\n%%\n");
  fprintf(fid, "fixnodes = [\n");

  mxdofpnt = cmp.dofs.mxdofpnt;

  for n = 1 : cmp.dofs.ndofp - 1
      id  = floor((cmp.dofs.dofp(n) - 1) / mxdofpnt) + 1;
      dof = mod(cmp.dofs.dofp(n) - 1, mxdofpnt) + 1;
      fprintf(fid, "  %5.0d   , %1.0d ,   0.000000000e+00  ;\n",
              id, dof);
  end
  id  = floor((cmp.dofs.dofp(end) - 1) / mxdofpnt) + 1;
  dof = mod(cmp.dofs.dofp(end) - 1, mxdofpnt) + 1;
  fprintf(fid, "  %5.0d   , %1.0d ,   0.000000000e+00  ] ;\n",
          id, dof);

# Loads

  fprintf(fid, "%%\n%% Point Loads\n%%\n");
  fprintf(fid, "pointload = [ ] ;\n");

  fprintf(fid, "%%\n%% Surface Loads\n%%\n");
  fprintf(fid, "uniload = sparse(%3.0d, 1 );\n", cmp.elements.nofelt);

end
