# Mefisto Mechanical Field Simulation Tools for GNU Octave
# Version 2.7
# Tested with Octave 9.1.0, 9.2.0 and 9.3.0 (Ubuntu 22.04 and Windows 10)
# Copyright (c) 2025 by Johannes Wandinger, University of Applied Sciences 
# Munich
# E-Mail: johannes.wandinger@hm.edu
#
# -----------------------------------------------------------------------------
#
# Mefisto is a set of functions for mechanical field simulations with 
# GNU Octave.
#
# To avoid conflicts with other functions, all function names start with mfs_.
#
# To get information on a specific function, type
#    help <functionname>
# where <functionname> has to be replaced by the actual name of the function.
#
# The Mefisto version number is reported by mfs_version.
#
# -----------------------------------------------------------------------------
#
# Mefisto is free software published under the GNU General Public License,
# see the license file in the license directory.
#
# -----------------------------------------------------------------------------
#
# List of functions
# =================
#
# Model generation
# ----------------
#
# mfs_import           - Import the model description from a preprocessor
# mfs_midnodes         - Generate nodes in the middle between existing nodes
# mfs_linenodes        - Generate nodes on a line between two existing nodes
# mfs_line             - Generate nodes and elements on a line between two
#                        existing nodes
# mfs_beamsection      - Compute beam cross section properties
# mfs_eset2nset        - Build node set from element set
# mfs_airfoil          - Return piecewise polynomial defining airfoil camber
# mfs_new              - Generate a new component from a model description
#
# Computation
# -----------
#
# mfs_stiff            - Compute the stiffness matrix
# mfs_mass             - Compute the mass matrix
# mfs_massproperties   - Compute the rigid body mass properties
# mfs_splines          - Compute the spline matrices
# mfs_statresp         - Compute the static response
# mfs_freevib          - Compute the free vibrations
# mfs_reductionerror   - Compute the modal strain energies and estimate the
#                        error in strain energies due to modal reduction
# mfs_meffmass         - Compute the modal effective masses
# mfs_freqresp         - Compute the frequency response
# mfs_transresp        - Compute the transient response
# mfs_trim             - Perform a trim analysis
# mfs_flutter          - Perform a flutter analysis
# mfs_diverg           - Perform a static divergence analysis
# mfs_back             - Perform backtransformation from modal to phyisical
#                        coordinates
# mfs_extract          - Extract a subcomponent
# mfs_results          - Compute secondary results
#
# Output
# ------
#
# mfs_plot             - Plot results using the GNU/Octave plot functions
# mfs_print            - Write results to the output file
# mfs_beamstress       - Compute and output beam stresses
# mfs_export           - Export the mesh or the results to a postprocessor
# mfs_getresp          - Retrieve selected responses
# mfs_xydata           - Retrieve selected data for xy-plots
# mfs_modecont         - Compute modal contributions
# mfs_randresp         - Compute random response
#
# Utilities
# ---------
#
# mfs_version          - Report the Mefisto version number
# mfs_peaks            - Find maxima or minima of a function
# mfs_freq2time        - Compute the inverse Fourier transform
# mfs_merge            - Merge two files
# mfs_vortex2d         - Compute 2-dim. airfoil aerodynamic coefficents
# mfs_transfer         - Transfer data from solid to aerodynamic component
#                        or vice versa

help mefisto
