function varargout = mfs_back(cmp, class, item, varargin)

# usage: varargout = mfs_back(cmp, class, item, varargin)
#
# Input  cmp        Structure with component data
#        class      Response class
#        item       Respone item
#        varargin   Additional data selecting response to be processed
#
# Output varargout  Output data
#
# The function performs the back transformation of modal results to
# physical results.
#
# --------------------------------------------------------------------

# Copyright (c) 2020 by Johannes Wandinger

  t0 = clock();

# Check arguments

  if (nargin < 3 || nargout < 1)
     print_usage();
  end
  if (! isstruct(cmp))
     error("mfs_back: first argument must be a structure\n");
  end
  if (! ischar(class))
     error("mfs_back: class must be a string\n");
  end
  if (! ischar(item))
     error("mfs_back: item must be a string\n");
  end

# Branch according to component type

  switch cmp.type

  case "solid"
     mfs_paths("add", "mfs_back.m", "solid");
     [cmp, out, rc] = mfs_backx(cmp, class, item, varargin);
     varargout = {cmp, out};
     mfs_paths("remove");

  case "aero"
     mfs_paths("add", "mfs_back.m", "aero");
     [cmp, out, rc] = mfs_backx(cmp, class, item, varargin);
     varargout = {cmp, out};
     mfs_paths("remove");

  case "aeroelastic"
     mfs_paths("add", "mfs_back.m", "aeroelastic");
     [cmps, cmpa, rc] = mfs_backc(cmp, class, item, varargin);
     varargout = {cmps, cmpa};
     mfs_paths("remove");

  otherwise
     rc = 1;
     printf("mfs_back: component type \"%s\" not supported\n",
            cmp.type);
  end

  if (rc)
     error("mfs_back: could not perform back transformation\n");
  end

# End

  elapsed_time = etime(clock(), t0);
  printf("%10.4f seconds needed to perform back transformation\n", ...
         elapsed_time);
  fflush(stdout);

end
