function [geom, e] = mfs_beamsection(type, varargin)

# usage: [geom, e] = mfs_beamsection(type, varargin)
#
# Input  type         Beam section type
#        varargin{}   List of additional arguments
#
# Output geom         Structure with geometry data
#        e(2)         ey and ez of center of mass
#
# Supported beam sections:
#
#  type         arguments
#  ------------------------------------------------------------------------
#  "bar"        b, h
#  "box"        "thin", b, h, t
#               "thick", ba, ha, t
#  "circle"     r
#  "ring"       "thin", r, t
#               "thick", Ra, Ri
#  "T"          b, h, t, "rot"
#  "I"          b, h, t, s
#  "Z"          "right"/"left", b, h, t, s, "rot"
#
# -------------------------------------------------------------------------

# Copyright(c) by 2022 Johannes Wandinger

# Check arguments

  if (nargin < 2 || nargout > 2)
     print_usage();
  end

  if (! ischar(type))
     error("mfs_beamsection: first argument must be a string\n");
  end

# Call section function

  mfs_paths("add", "mfs_beamsection.m", "solid/sections");

  fname = ["mfs_", type, "_section"];

  if (exist(fname, "file") == 2)
     sfunc = str2func(fname);
     [geom, e, rc] = sfunc(varargin);
     mfs_paths("remove");
     if (rc)
        error("mfs_beamsection ended with errors\n");
     end
  else
     mfs_paths("remove");
     error("mfs_beamsection: unknown beam section type \"%s\"\n", type);
  end

end
