function cmpx = mfs_extract(cmp, subcmp)
  
# usage: cmpx = mfs_extract(cmp, subcmp)
#
# Input  cmp     Structure with component data
#        subcmp  Name of subcomponent to extract
#
# Output cmpx    Structure with extracted component
#
# The function extracts a subcomponent from a component.
#
# ---------------------------------------------------------------------

# Copyright (c) 2019 by Johannes Wandinger

# Initialize

  t0   = clock();
  cmpx = struct();

# Check arguments

  if (nargin != 2 || nargout != 1)
     print_usage();
  end

  if (! isstruct(cmp))
     error("mfs_extract: first argument must be a structure\n");
  end
  if (! isfield(cmp, "type"))
     error("mfs_extract: first argument is not a component\n");
  end
  if (! ischar(subcmp))
     error("mfs_extract: second argument must be a string\n");
  end

# Extract component

  switch cmp.type

  case "aeroelastic"

     switch subcmp
        case "solid"
           cmpx = cmp.solid;
        case "aero"
           cmpx = cmp.aero;
        otherwise
           error("mfs_extract: illegal subcomponent name \"s\"\n",
                 subcmp);
     end

  otherwise
     error("mfs_extract: component type \"s\" not supported\n",
           cmp.type);
  end

# End

  elapsed_time = etime(clock(), t0);
  printf("%10.4f seconds needed to extract subcomponent %s from component %s\n",
         elapsed_time, subcmp, inputname(1));
  fflush(stdout);

end
