function varargout = mfs_getresp(cmp, class, item, varargin)

# usage: varargout = mfs_getresp(cmp, class, item, varargin)
#
# Input  cmp        Structure with component data
#        class      Response class
#        item       Response item
#        varargin   Additional output data selectors
#
# Output varargout  Output data
#
# The function returns selected items.
#
# -------------------------------------------------------------------------

# Copyright (c) 2024 by Johannes Wandinger

  t0 = clock();

# Check arguments

  if (nargin < 3 || nargout < 1)
     print_usage();
  end
  if (! isstruct(cmp))
     error("mfs_getresp: first argument must be a structure\n");
  end
  if (! ischar(class))
     error("mfs_getresp: class must be a string\n");
  end
  if (! ischar(item))
     error("mfs_getresp: item must be a string\n");
  end

# Branch according to component type

  switch cmp.type

  case "solid"
     time_stamp = ignore_function_time_stamp("all");
     mfs_paths("add", "mfs_getresp.m", "solid", "util",
               "solid/elem/util");
     [varargout, rc] = mfs_getrespx(cmp, class, item, varargin);
     mfs_paths("remove");
     ignore_function_time_stamp(time_stamp);

  case "aero"
     time_stamp = ignore_function_time_stamp("all");
     mfs_paths("add", "mfs_getresp.m", "aero", "util");
     [varargout, rc] = mfs_getrespx(cmp, class, item, varargin);
     mfs_paths("remove");
     ignore_function_time_stamp(time_stamp);

  case "aeroelastic"
     time_stamp = ignore_function_time_stamp("all");
     mfs_paths("add", "mfs_getresp.m", "aeroelastic", "util");
     [varargout, rc] = mfs_getrespc(cmp, class, item, varargin);
     mfs_paths("remove");
     ignore_function_time_stamp(time_stamp);

  otherwise
     rc = 1;
     printf("mfs_getresp: component type \"%s\" not supported\n",
            cmp.type);
  end

  if (rc)
     error("mfs_getresp: could not process all requests\n");
  end

# End

  elapsed_time = etime(clock(), t0);
  printf("%10.4f seconds needed to retrieve response data of component %s\n",
         elapsed_time, inputname(1));
  fflush(stdout);

end
