function items = mfs_getset(cmp, settype, setname)

# usage: items = mfs_getset(cmp, settype, setname)
#
# Input  cmp        Structure with component data
#        settype    Type of set (nset or eset)
#        setname    Name of set
#
# Output items(:)   List of identifiers of items in the set
#
# The function returns the identifiers of the items contained in
# the specified set.
#
# --------------------------------------------------------------------

# Copyright (c) 2023 by Johannes Wandinger

  items = [];

# Check arguments

  if (nargin !=3 || nargout != 1)
     print_usage();
  end
  if (! isstruct(cmp))
     error("mfs_getset: first argument must be a structure\n");
  end
  if (! ischar(settype))
     error("mfs_getset: settype must be a string\n");
  end
  if (! ischar(setname))
     error("mfs_getset: setname must be a string\n");
  end

# Branch according to set type

  switch settype

  case "nset"

     if (isfield(cmp.nset, setname))
        idx   = cmp.nset.(setname);
        items = cmp.nodes.ids(idx);
     else
        error("mfs_getset: node set %s does not exist\n", setname);
     end

  case "eset"

     if (isfield(cmp.eset, setname))
        idx1  = cmp.eset.(setname);
        idx2  = cmp.elements.index(idx1, 2);
        items = [cmp.elements.elem.id](idx2);
     else
        error("mfs_getset: element set %s does not exist\n", setname);
     end

  otherwise
     error("mfs_getset: unknown settype %s\n", settype);
  end

end
