function mfs_merge(fnin1, fnin2, fnout, format)

# usage: mfs_merge(fnin1, fnin2, fnout, format)
#
# Input  fnin1     Nume of first input file
#        fnin2     Name of second input file
#        fnout     Name of output file
#        format    File format
#
# The function merges to files into one.
#
# -----------------------------------------------------------------------------

# Copyright (c) 2017 by Johannes Wandinger

  t0 = clock();

# Check arguments

  if (nargin != 4 || nargout != 0)
     print_usage();
  end

  if (! ischar(fnin1))
     error("mfs_import: first input argument must be a file name\n");
  end
  if (! ischar(fnin2))
     error("mfs_import: second input argument must be a file name\n");
  end
  if (! ischar(fnout))
     error("mfs_import: third input argument must be a file format\n");
  end
  if (! ischar(format))
     error("mfs_import: fourth input argument must be a string\n");
  end

# Branch according to file format

  rc = 0;
  switch format
  case {"msh", "msh22", "msh41"}
     switch format
     case "msh22"
        vers = "2.2";
     case {"msh", "msh41"}
        vers = "4.1";
     endswitch
     time_stamp = ignore_function_time_stamp("all");
     mfs_paths("add", "mfs_merge.m", "private", "msh/util",
               ["msh/util/", vers]);
     mfs_mergex(fnin1, fnin2, fnout)
     mfs_paths("remove");
     ignore_function_time_stamp(time_stamp);
  otherwise
     error("mfs_merge: File format %s not supported\n", format);      
  end

# End

  elapsed_time = etime(clock(), t0);
  printf("%10.4f seconds needed to merge files %s and %s\n", ...
          elapsed_time, fnin1, fnin2);

  fflush(stdout);

end
