function nodes = mfs_midnodes(nodes, midnodes)

# usage:  nodes = mfs_midnodes(nodes, midnodes)
#
# Input  nodes      Structure array with nodal point data
#        midnodes   Array with definition of mid nodes
#                   [idm, ix1, ix2]
#
# Output nodes      Structure array with nodal point data
#
# The function adds the mid nodes and their coordinates to the
# structure array with nodal point data. The mid node idm lies in the
# middle between existing nodes with indices ix1 and ix2 in nodes.
#
# ------------------------------------------------------------------------

# Copyright (c) 2015 by Johannes Wandinger

# Check arguments

  if (nargin !=2 || nargout != 1)
     print_usage();
  end

# Loop over mid nodes

  [nofmid, nc] = size(midnodes);
  nofnod       = length(nodes);
  ixn          = nofnod + 1;

  for n = 1 : nofmid
      id  = midnodes(n, 1);
      ix1 = midnodes(n, 2);
      ix2 = midnodes(n, 3); 
      nodes(ixn).coor  = 0.5 * (nodes(ix1).coor + nodes(ix2).coor);
      nodes(ixn++).id = id;
  end

end
