function fgh = mfs_plot(cmp, varargin)

# usage: fgh = mfs_plot(cmp, varargin)
#
# Input  cmp       Structure with component
#        varargin  Plot parameters
#
# Output fgh       Figure handle
#
# The function plots a component.
#
# Plot parameters:
#
#   Name     Values   Default  Meaning
#  ---------------------------------------------------------------
#   nodid     0 / 1      0     Plot node identifiers
#   eltid     0 / 1      0     Plot element identifiers
#   deform    0 / 1, 2   0     Deformed plot: 2 = undeformed and
#                              deformed
#   force     0 / 1, 2   0     Plot applied forces: 2 = force labels
#   reac      0 / 1, 2   0     Plot reaction forces: 2 = force labels
#   loadcase   lcs       1     Loadcase list
#   modes      lcs       0     List of normal modes
#   beamaxis   0 / 1     0     Plot beam z-axis
#   scald               0.1    Scale factor for deformed plot
#   scalf               0.1    Scale factor for load arrows
#   scalax              0.4    Scale factor for beam axis
#   figure               0     Handle of existing figure
#
# Parameters defining graphic properties:
#
#   Name          Default      Meaning
#  ---------------------------------------------------------------
#   position                   Screen position of the plot
#   paperposition              Paper position of the plot
#   outerposition              Axis outerposition property
#   visible        "off"       Axis visibility
#   fontsize        14         Fontsize
#   fontname         *         Fontname
#   view         [30, 60]      Elevation (measured from z-axis) and
#                              azimuth
#
# ---------------------------------------------------------------------

# Copyright (c) 2017 by Johannes Wandinger

  t0 = clock();

# Check arguments

  if (nargin == 0)
     print_usage();
  end

  if (! isstruct(cmp))
     error("mfs_plot: first argument must be a structure\n");
  end

  time_stamp = ignore_function_time_stamp("all");

# Branch on model type

  switch cmp.type
  case "solid"
     mfs_paths("add", "mfs_plot.m", "solid");
     fgh = mfs_plotx(cmp, varargin);
     mfs_paths("remove");
  otherwise
     printf("mfs_plot does not support components of type \"%s\"",
            cmp.type);
  end

# End

  ignore_function_time_stamp(time_stamp);
  elapsed_time = etime(clock(), t0);
  printf("%10.4f seconds needed to plot component %s\n", ...
         elapsed_time, inputname(1));
  fflush(stdout);

end
