function mfs_print(fid, cmp, class, varargin)

# usage: mfs_print(fid, cmp, class, varargin)
#
# Input  fid       File handle 
#        cmp       Structure with component
#        class     Output data class
#        varargin  Print requests
#
# The function prints the results of a component.
#
# Print requests depend on the component type.
#
# ---------------------------------------------------------------------

# Copyright (c) 2015 by Johannes Wandinger

  t0 = clock();

# Check arguments

  if (nargin < 4)
     print_usage();
  end

  if (! is_valid_file_id(fid))
     error("mfs_print: first argument does not refer to an open file\n");
  end
  if (! isstruct(cmp))
     fclose(fid);
     error("mfs_print: second argument is not a structure\n");
  end
  if (! ischar(class))
     fclose(fid);
     error("mfs_print: third argument is not a string\n");
  end

# Header

  fprintf(fid, "\n");
  for k = 1 : 8
      fprintf(fid, "----------");
  end
  fprintf(fid, "\n\nComponent ""%s""\n\n", inputname(2));

# Branch on model type

  switch cmp.type

  case "solid"
     time_stamp = ignore_function_time_stamp("all");
     mfs_paths("add", "mfs_print.m", "solid", "util", 
                                     "solid/elem/util");
     mfs_printx(fid, cmp, class, varargin);
     mfs_paths("remove");
     ignore_function_time_stamp(time_stamp);

  case "aero"
     time_stamp = ignore_function_time_stamp("all");
     mfs_paths("add", "mfs_print.m", "aero", "util");
     mfs_printx(fid, cmp, class, varargin);
     mfs_paths("remove");
     ignore_function_time_stamp(time_stamp);

  case "aeroelastic"
     time_stamp = ignore_function_time_stamp("all");
     mfs_paths("add", "mfs_print.m", "aeroelastic");
     mfs_printc(fid, cmp, class, varargin);
     mfs_paths("remove");
     ignore_function_time_stamp(time_stamp);

  otherwise
     printf("mfs_print: model type \"%s\" not supported\n", cmp.type);

  end

# End

  elapsed_time = etime(clock(), t0);
  printf("%10.4f seconds needed to print results of component %s\n",
         elapsed_time, inputname(2));
  fflush(stdout);

end
