function cmp = mfs_results(cmp, class, varargin)

# usage: cmp = mfs_results(cmp, class, varargin)
#
# Input  cmp        Structure with component
#        class      Result class
#        varargin   List of items
#
# Output cmp        Structure with component
#
# The function computes secondary results.
#
# List of results:
#
#  class = statresp
#        element    Element results: stress, strain,
#                                    stress resultants
#
# --------------------------------------------------------------------

# Copyright (c) 2015 by Johannes Wandinger

  t0 = clock();

# Check arguments

  if (nargin < 3 || nargout != 1)
     print_usage();
  end

  if (! isstruct(cmp))
     error("mfs_results: first argument must be a structure\n");
  end

  if (! ischar(class))
     error("mfs_results: second argument must be a string\n");
  end

# Branch acoording to component type and subtype

  switch cmp.type

  case "solid"
     time_stamp = ignore_function_time_stamp("all");
     mfs_paths("add", "mfs_results.m", "solid",
               "solid/elem/util");
     [cmp, rc] = mfs_resultsx(cmp, class, varargin);
     mfs_paths("remove");
     ignore_function_time_stamp(time_stamp);

  case "aero"
     time_stamp = ignore_function_time_stamp("all");
     mfs_paths("add", "mfs_results.m", "aero", "util");
     [cmp, rc] = mfs_resultsx(cmp, class, varargin);
     mfs_paths("remove");
     ignore_function_time_stamp(time_stamp);

  otherwise
     rc = 1;
     printf("mfs_results: component type \"%s\" not supported\n", ...
            cmp.type);
  end

  if (rc)
     error("mfs_results: could not process all requests\n");
  end

# End

  elapsed_time = etime(clock(), t0);
  printf("%10.4f seconds needed to compute secondary results ", ...
         elapsed_time);
  printf("of component %s\n", inputname(1));
  fflush(stdout);

end
