function cmp = mfs_splines(cmp)

# usage: cmp = mfs_splines(cmp)
#
# Input  cmp   Structure with component data
#
# Output cmp   Structure with component data
#              (Spline matrices added)
#
# The function comutes the spline matrices of a coupled component.
#
# --------------------------------------------------------------------

# Copyright (c) 2016 by Johannes Wandinger

  t0 = clock();

# Check arguments

  if (nargin != 1 || nargout != 1)
     print_usage();
  end
  if (! isstruct(cmp))
     error("mfs_splines: argument must be a structure\n");
  end

# Branch according to type

  switch cmp.type
  case "aeroelastic"
     mfs_paths("add", "mfs_splines.m", "aeroelastic", "util");
     cmp = mfs_splinesx(cmp);
     mfs_paths("remove");
  otherwise
     error("mfs_splines: component subtype \"%s\" not supported\n", ...
           cmp.subtype);
  end

# End

  elapsed_time = etime(clock(), t0);
  printf("%10.4f seconds needed to compute spline matrices\n", ...
         elapsed_time);
  fflush(stdout);

end
