function cmp = mfs_stiff(cmp)

# usage: cmp = mfs_stiff(cmp)
#
# Input  cmp     Structure with component data
#
# Output cmp     Structure with component data 
#                (stiffness matrix added)
#
# The function computes the stiffness matrix of a component.
#
# ---------------------------------------------------------------------

# Copyright (c) 2017 by Johannes Wandinger

  t0 = clock();

# Check arguments

  if (nargin != 1 || nargout != 1)
     print_usage();
  end
  if (! isstruct(cmp))
     error("mfs_stiff: argument must be a structure\n");
  end
  if (! strcmp(cmp.type, "solid"))
     error("mfs_stiff: component type must be \"solid\"\n");
  end

  time_stamp = ignore_function_time_stamp("all");

# Manage paths

  mfs_paths("add", "mfs_stiff.m", "solid", "solid/elem/util");

  bpath = file_in_loadpath("mfs_stiff.m");
  len   = length(bpath) - length("mfs_stiff.m");
  bpath = strcat(bpath(1 : len), "solid/elem/", cmp.subtype, "/");

# Initialize the stiffness matrix

  ndofg = cmp.dofs.ndofg;
  K     = sparse(ndofg, ndofg);

# Element loop to assemble stiffness matrix

  elem = cmp.elements.elem;

  for l = 1 : cmp.elements.noftyp

      epath = strcat(bpath, cmp.elements.types(l).name);
      addpath(epath);

      if (exist("mfs_ke", "file") == 2)

         m1 = cmp.elements.types(l).ixelt1;
         m2 = m1 + cmp.elements.types(l).nofelt - 1;

         for m = m1 : m2
             ect = elem(m).ects;
             K(ect, ect) = K(ect, ect) + mfs_ke(elem(m)); 
         end

      end

      rmpath(epath);

  end 

# End

  mfs_paths("remove");

  cmp.stiff = struct("K", K);

  elapsed_time = etime(clock(), t0);
  printf("%10.4f seconds needed to assemble %5d by %5d stiffness matrix\n", ...
         elapsed_time, ndofg, ndofg);
  fflush(stdout);

  ignore_function_time_stamp(time_stamp);

end
