function varargout = mfs_xydata(cmp, class, item, varargin)

# usage: varargout = mfs_xydata(cmp, class, item, varargin)
#
# Input  cmp        Structure with component data
#        class      Response class
#        item       Response item
#        varargin   Additional output data selectors
#
# Output varargout  Output data
#
# The function returns selected data that can be used for xy-plots.
#
# ---------------------------------------------------------------------

# Copyright (c) 2017 by Johannes Wandinger

  t0 = clock();

# Check arguments

  if (nargin < 3 || nargout < 1)
     print_usage();
  end
  if (! isstruct(cmp))
     error("mfs_xydata: first argument must be a structure");
  end
  if (! ischar(class))
     error("mfs_xydata: class must be a string");
  end
  if (! ischar(item))
     error("mfs_xydata: item must be a string");
  end

# Branch according to component type and subtype

  switch cmp.type

  case "aero"
     mfs_paths("add", "mfs_xydata.m", "aero");
     [varargout, rc] = mfs_xydatax(cmp, class, item, varargin);
     mfs_paths("remove");

  otherwise
     rc = 1;
     printf("mfs_xydata: component type "\s\" not supported\n",
            cmp.type);
  end

  if (rc)
     error("mfs_xydata: could not process all requests\n");
  end

# End

  elapsed_time = etime(clock(), t0);
  printf("%10.4f seconds needed to retrieve xy-data of component %s\n",
         elapsed_time, inputname(1));
  fflush(stdout);

end
