function mfs_exp_cdisp(fid, cmp, disp, title)

# usage: mfs_exp_cdisp(fid, cmp, disp, title)
#
# Input  fid         File handle of output file
#        cmp         Structure with component
#        disp(:, :)  Displacements
#        title(:)    Cell array with view names
#
# The function exports complex displacements in Gmsh MSH file format. The
# real part is written as time step 0 and the imaginary part as time step
# 1.
#
# ------------------------------------------------------------------------

  zero = 0.;

# Get parameters needed

  nofnod   = cmp.nodes.nofnod;
  [m, nlc] = size(disp);

# Define function to write the displacements

  prt = @(id, u) fprintf(fid, "%-5d %-10.3e %-10.3e %-10.3e\n", id, u);

# Loop over loadcases

  for l = 1 : nlc

#     Real Part

      fprintf(fid, "$NodeData\n");

      fprintf(fid, "1\n""%s""\n", title{l});
      fprintf(fid, "1\n%-10.3f\n", zero);
      fprintf(fid, "3\n%-3d\n3\n%-5d\n", 0, nofnod);

      dof = 0;
      for n = 1 : nofnod
          id = cmp.nodes.ids(n);
          for k = 1 : 3
              u(k) = real(disp(++dof, l));
          end
          prt(id, u);
      end

      fprintf(fid, "$EndNodeData\n");

#     Imaginary Part

      fprintf(fid, "$NodeData\n");

      fprintf(fid, "1\n""%s""\n", title{l});
      fprintf(fid, "1\n%-10.3f\n", zero);
      fprintf(fid, "3\n%-3d\n3\n%-5d\n", 1, nofnod);

      dof = 0;
      for n = 1 : nofnod
          id = cmp.nodes.ids(n);
          for k = 1 : 3
              u(k) = imag(disp(++dof, l));
          end
          prt(id, u);
      end

      fprintf(fid, "$EndNodeData\n");

  end   % Loadcase loop

end
