function mfs_exp_mesh(fid, cmp)

# usage: mfs_exp_mesh(fid, cmp)
#
# Input  fid     File handle of output file
#        cmp     Structure with component
#
# This function exports the mesh in Gmsh MSH file format.
#
# ------------------------------------------------------------------------

# Check arguments

  if (nargin != 2)
     print_usage();
  end

# Function to print nodal points

  prtcoor = @(id, coor) fprintf(fid, "%d %f %f %f\n", id, coor);

# Physical Names

  fprintf(fid, "$PhysicalNames\n")
  fprintf(fid, "%d\n", cmp.ls.nofls);
  for l = 1 : cmp.ls.nofls
      fprintf(fid, "2 %d \"%s\"\n", cmp.ls.ids(l), ...
              sprintf("Lifting_Surface_%d", cmp.ls.ids(l)));
  end
  fprintf(fid, "$EndPhysicalNames\n");

# Nodal point data

  fprintf(fid, "$Nodes\n");

  nofnod = cmp.nodes.nofnod;
  fprintf(fid, "%d\n", nofnod);

  for n = 1 : nofnod
      prtcoor(cmp.nodes.ids(n), cmp.nodes.coor(n, :));
  end

  fprintf(fid, "$EndNodes\n");

# Panel data

  fprintf(fid, "$Elements\n");

  fprintf(fid, "%d\n", cmp.panels.nofpan);

  noftag   = 2;
  gmshtype = 3;
  ixnod    = [1, 2, 4, 3];

  for l = 1 : cmp.ls.nofls
      tags(1) = cmp.ls.ids(l);
      tags(2) = tags(1);
      for n = cmp.ls.surfs(l).p1 : cmp.ls.surfs(l).pend
          fprintf(fid, "%d %d %d %d %d", ...
                  n, gmshtype, noftag, tags);
          fprintf(fid, " %d %d %d %d\n", ...
                  cmp.panels.corner(ixnod, n));
      end 
  end
  
  fprintf(fid, "$EndElements\n");

end
