function mfs_exp_mesh_normals(fid, cmp)

# usage: mfs_exp_mesh_normals(fid, cmp)
#
# Input  fid     File handle of output file
#        cmp     Structure with component
#
# This function exports panel normals to the Gmsh MSH file.
#
# ------------------------------------------------------------------------

# Check arguments

  if (nargin != 2)
     print_usage();
  end

# Get panel normals

  nofpan = cmp.panels.nofpan;
  nvecs  = zeros(3, nofpan);

  for l = 1 : cmp.ls.nofls             % Loop over lifting surfaces
      for n = cmp.ls.surfs(l).p1 : cmp.ls.surfs(l).pend
          nvecs(:, n) = cmp.ls.surfs(l).nvec(:);
      end
  end                                  % Loop over lifting surfaces

# Write panel normals to the output file

  fprintf(fid, "$ElementData\n");

  fprintf(fid, "1\n""%s""\n", "Panel Normals");
  fprintf(fid, "1\n0.0000\n");
  fprintf(fid, "3\n0\n3\n%-5d\n", nofpan);

  for n = 1 : nofpan
      fprintf(fid, "%-5d %-12.5f %-12.5f %-12.5f\n",n, nvecs(:, n));
  end

  fprintf(fid, "$EndElementData\n");

end
