function mfs_exp_panel_cscalar(fid, panres, s, title)

# usage: mfs_exp_panel_cscalar(fid, panres, title)
#
# Input  fid         File identifier of output file
#        panres      Structure with panel results
#        s(:, :)     Array with scalar data
#        title{:}    Cell array with view names      
#
# The function exports complex scalar panel results in Gmsh MSH file
# format.
#
# --------------------------------------------------------------------

  zero = 0;

# Get dimensions

  [nofpan, ncol] = size(s);

# Loop over columns

  for n = 1 : ncol

#     Real Part

      fprintf(fid, "$ElementData\n");

      fprintf(fid, "1\n""%s""\n", title{n});
      fprintf(fid, "1\n%-10.3f\n", zero);
      fprintf(fid, "3\n%-3d\n1\n%-5d\n", 0, nofpan);

      for m = 1 : nofpan
          fprintf(fid, "%-5d %-10.3e\n", m, real(s(m, n)));
      end

      fprintf(fid, "$EndElementData\n");

#     Imaginary Part

      fprintf(fid, "$ElementData\n");

      fprintf(fid, "1\n""%s""\n", title{n});
      fprintf(fid, "1\n%-10.3f\n", zero);
      fprintf(fid, "3\n%-3d\n1\n%-5d\n", 1, nofpan);

      for m = 1 : nofpan
          fprintf(fid, "%-5d %-10.3e\n", m, imag(s(m, n)));
      end

      fprintf(fid, "$EndElementData\n");

  end

end
