function mfs_exp_panel_scalar(fid, panres, s, title)

# usage: mfs_exp_panel_scalar(fid, panres, title)
#
# Input  fid         File identifier of output file
#        panres      Structure with panel results
#        s(:, :)     Array with scalar data
#        title{:}    Cell array with view names      
#
# The function exports scalar panel results in Gmsh MSH file format.
#
# --------------------------------------------------------------------

  zero = 0;

# Get dimensions

  [nofpan, nconf] = size(s);

# Loop over configurations

  for n = 1 : nconf

#     Header

      fprintf(fid, "$ElementData\n");

#     Tags

      fprintf(fid, "1\n""%s""\n", title{n});
      fprintf(fid, "1\n%-10.3f\n", zero);
      fprintf(fid, "3\n%-3d\n1\n%-5d\n", 0, nofpan);

#     Data

      for m = 1 : nofpan
          fprintf(fid, "%-5d %-10.3e\n", m, s(m, n));
      end

#     End

      fprintf(fid, "$EndElementData\n");

  end

end
