function mfs_exp_panel_vector(fid, panres, v, title)

# usage: mfs_exp_panel_vector(fid, panres, title)
#
# Input  fid            File identifier of output file
#        panres         Structure with panel results
#        v(3, :, :)     Array with vector data
#        title{:}       Cell array with view names      
#
# The function exports vector panel results in Gmsh MSH file format.
#
# --------------------------------------------------------------------

  zero = 0;

# Get dimensions

  [nc, nofpan, nconf] = size(v);

# Loop over configurations

  for n = 1 : nconf

#     Header

      fprintf(fid, "$ElementData\n");

#     Tags

      fprintf(fid, "1\n""%s""\n", title{n});
      fprintf(fid, "1\n%-10.3f\n", zero);
      fprintf(fid, "3\n%-3d\n3\n%-5d\n", 0, nofpan);

#     Data

      for m = 1 : nofpan
          fprintf(fid, "%-5d %-10.3e %-10.3e %-10.3e\n", m, v(:, m, n));
      end

#     End

      fprintf(fid, "$EndElementData\n");

  end

end
