function mfs_exp_cdisp(fid, cmp, dsp, title)

# usage: mfs_exp_cdisp(fid, cmp, dsp, title)
#
# Input  fid         File handle of output file
#        cmp         Structure with component
#        dsp(:, :)   Displacements
#        title(:)    Cell array with view names
#
# The function exports complex displacements in Gmsh MSH file format. The
# real part is written as time step 0 and the imaginary part as time step
# 1.
#
# ------------------------------------------------------------------------

  zero = 0.;

# Get parameters needed

  nofnod = cmp.nodes.nofnod;
  nlc    = columns(dsp); 

# Loop over loadcases

  for l = 1 : nlc

      u = reshape(dsp(:, l), 3, nofnod);

#     Real Part

      fprintf(fid, "$NodeData\n");

      fprintf(fid, "1\n\"%s\"\n", title{l});
      fprintf(fid, "1\n%f\n", zero);
      fprintf(fid, "3\n%d\n3\n%d\n", 0, nofnod);

      values = [cmp.nodes.ids; real(u)];
      fprintf(fid, "%d %e %e %e\n", values);

      fprintf(fid, "$EndNodeData\n");

#     Imaginary Part

      fprintf(fid, "$NodeData\n");

      fprintf(fid, "1\n\"%s\"\n", title{l});
      fprintf(fid, "1\n%f\n", zero);
      fprintf(fid, "3\n%d\n3\n%d\n", 1, nofnod);

      values(2 : 4, :) = imag(u);
      fprintf(fid, "%d %e %e %e\n", values);

      fprintf(fid, "$EndNodeData\n");

  end   % Loadcase loop

end
