function mfs_exp_disp(fid, cmp, dsp, title)

# usage: mfs_exp_disp(fid, cmp, dsp, title)
#
# Input  fid         File handle of output file
#        cmp         Structure with component
#        dsp(:, :)   Displacements
#        title(:)    Cell array with view names
#
# The function exports displacements of an aerodynamic component in Gmsh 
# MSH file format.
#
# ------------------------------------------------------------------------

  zero = 0.;

# Get parameters needed

  nofnod = cmp.nodes.nofnod;
  nlc    = columns(dsp);

# Loop over loadcases

  for l = 1 : nlc

#     Header

      fprintf(fid, "$NodeData\n");

#     Tags

      fprintf(fid, "1\n\"%s\"\n", title{l});
      fprintf(fid, "1\n%f\n", zero);
      fprintf(fid, "3\n%d\n3\n%d\n", 0, nofnod);

#     Data

      u = reshape(dsp(:, l), 3, nofnod);
      values = [cmp.nodes.ids; u];
      fprintf(fid, "%d %e %e %e\n", values);

#     End

      fprintf(fid, "$EndNodeData\n");

  end   % Loadcase loop

end
