function mfs_exp_mesh_normals(fid, cmp)

# usage: mfs_exp_mesh_normals(fid, cmp)
#
# Input  fid     File handle of output file
#        cmp     Structure with component
#
# This function exports panel normals to the Gmsh MSH file.
#
# ------------------------------------------------------------------------

# Check arguments

  if (nargin != 2)
     print_usage();
  endif

# Get panel normals

  nofpan = cmp.panels.nofpan;
  nvecs  = zeros(3, nofpan);

  for l = 1 : cmp.ls.nofls 
      n1 = cmp.ls.surfs(l).p1;
      n2 = cmp.ls.surfs(l).pend;
      n  = n2 - n1 + 1;
      nvecs(:, n1 : n2) = repmat(cmp.ls.surfs(l).nvec, 1, n);
  endfor

# Write panel normals to the output file

  fprintf(fid, "$ElementData\n");

  fprintf(fid, "1\n\"%s\"\n", "Panel Normals");
  fprintf(fid, "1\n0.0000\n");
  fprintf(fid, "3\n0\n3\n%d\n", nofpan);

  values = [1 : nofpan; nvecs];
  fprintf(fid, "%d %f %f %f\n", values);

  fprintf(fid, "$EndElementData\n");

endfunction
