function mfs_exp_panel_cscalar(fid, panres, s, title)

# usage: mfs_exp_panel_cscalar(fid, panres, title)
#
# Input  fid         File identifier of output file
#        panres      Structure with panel results
#        s(:, :)     Array with scalar data
#        title{:}    Cell array with view names      
#
# The function exports complex scalar panel results in Gmsh MSH file
# format.
#
# --------------------------------------------------------------------

  zero = 0;

# Get dimensions

  [nofpan, ncol] = size(s);

# Loop over columns

  for n = 1 : ncol

#     Real Part

      fprintf(fid, "$ElementData\n");

      fprintf(fid, "1\n\"%s\"\n", title{n});
      fprintf(fid, "1\n%f\n", zero);
      fprintf(fid, "3\n%d\n1\n%d\n", 0, nofpan);

      values = [1 : nofpan; real(s(:, n))'];
      fprintf(fid, "%d %e\n", values);

      fprintf(fid, "$EndElementData\n");

#     Imaginary Part

      fprintf(fid, "$ElementData\n");

      fprintf(fid, "1\n\"%s\"\n", title{n});
      fprintf(fid, "1\n%f\n", zero);
      fprintf(fid, "3\n%d\n1\n%d\n", 1, nofpan);

      values(2, :) = imag(s(:, n))';
      fprintf(fid, "%d %e\n", values);

      fprintf(fid, "$EndElementData\n");

  end

end
