function mfs_exp_panel_scalar(fid, panres, s, title)

# usage: mfs_exp_panel_scalar(fid, panres, title)
#
# Input  fid         File identifier of output file
#        panres      Structure with panel results
#        s(:, :)     Array with scalar data
#        title{:}    Cell array with view names      
#
# The function exports scalar panel results in Gmsh MSH file format.
#
# --------------------------------------------------------------------

  zero = 0;

# Get dimensions

  [nofpan, nconf] = size(s);

# Loop over configurations

  for n = 1 : nconf

#     Header

      fprintf(fid, "$ElementData\n");

#     Tags

      fprintf(fid, "1\n\"%s\"\n", title{n});
      fprintf(fid, "1\n%f\n", zero);
      fprintf(fid, "3\n%d\n1\n%d\n", 0, nofpan);

#     Data

      values = [1 : nofpan; s(:, n)'];
      fprintf(fid, "%d %e\n", values);

#     End

      fprintf(fid, "$EndElementData\n");

  end

end
