function mfs_exp_panel_vector(fid, panres, v, title)

# usage: mfs_exp_panel_vector(fid, panres, title)
#
# Input  fid            File identifier of output file
#        panres         Structure with panel results
#        v(3, :, :)     Array with vector data
#        title{:}       Cell array with view names      
#
# The function exports vector panel results in Gmsh MSH file format.
#
# --------------------------------------------------------------------

  zero = 0;

# Get dimensions

  [nc, nofpan, nconf] = size(v);

# Loop over configurations

  for n = 1 : nconf

#     Header

      fprintf(fid, "$ElementData\n");

#     Tags

      fprintf(fid, "1\n\"%s\"\n", title{n});
      fprintf(fid, "1\n%f\n", zero);
      fprintf(fid, "3\n%d\n3\n%d\n", 0, nofpan);

#     Data

      values = [1 : nofpan; v(:, :, n)];
      fprintf(fid, "%d %e %e %e\n", values);

#     End

      fprintf(fid, "$EndElementData\n");

  end

end
