function nodes = mfs_camber(cmp)

# usage: nodes = mfs_camber(cmp)
#
# Input  cmp    Structure with component
#
# Output nodes  Structures with modified nodes
#
# The function adds the camber to the nodal point coordinates.
#
# --------------------------------------------------------------------

  nodes = cmp.nodes;

  for ls = cmp.ls.surfs

      p1    = ls.p1;
      p2    = ls.pend;
      node1 = cmp.panels.corner(1, p1);
      node2 = cmp.panels.corner(4, p2);
      nodid = node1 : node2;

      z1 = ls.c(1) * ppval(ls.camber{1}, ls.tx);
      z2 = ls.c(2) * ppval(ls.camber{2}, ls.tx);

      z = z1' * (1 - ls.ty) + z2' * ls.ty;
      z = reshape(z, 1, length(nodid))';

      nodes.coor(nodid, 2 : 3) += z * ls.nvec(2 : 3)';

  end

end
