function mfs_exp_disp(fid, cmp, disp, title)

# usage: mfs_exp_disp(fid, cmp, disp, title)
#
# Input  fid         File handle of output file
#        cmp         Structure with component
#        disp(:, :)  Displacements
#        title(:)    Cell array with view names
#
# The function exports displacements in Gmsh MSH file format.
#
# ------------------------------------------------------------------------

  zero = 0.;

# Get parameters needed

  nofnod   = cmp.nodes.nofnod;
  ncoor    = cmp.nodes.ncoor;
  mxdofpnt = cmp.dofs.mxdofpnt;
  [m, nlc] = size(disp);

# Define function to write the displacements

  if (ncoor == 2)
     prt = @(id, u) fprintf(fid, "%-5d %-10.3e %-10.3e 0.0\n", id, u);
  else
     prt = @(id, u) fprintf(fid, "%-5d %-10.3e %-10.3e %-10.3e\n", id, u);
  end

# Number of rotational dofs per node (to be skipped)

  nrdof = mxdofpnt - ncoor;

# Loop over loadcases

  for l = 1 : nlc

#     Header

      fprintf(fid, "$NodeData\n");

#     Tags

      fprintf(fid, "1\n""%s""\n", title{l});
      fprintf(fid, "1\n%-10.3f\n", zero);
      fprintf(fid, "3\n%-3d\n3\n%-5d\n", 0, nofnod);

#     Data

      dof = 0;
      for n = 1 : nofnod
          id = cmp.nodes.ids(n);
          for k = 1 : ncoor
              u(k) = disp(++dof, l);
          end
          prt(id, u);
          dof += nrdof;
      end

#     End

      fprintf(fid, "$EndNodeData\n");

  end   % Loadcase loop

end
