function mfs_exp_mesh(fid, cmp)

# usage: mfs_exp_mesh(fid, cmp)
#
# Input  fid     File handle of output file
#        cmp     Structure with component
#
# This function exports the mesh in Gmsh MSH file format version 2.2.
#
# ------------------------------------------------------------------------

# Check arguments

  if (nargin != 2)
     print_usage();
  end

# Define subtype dependent data

  switch cmp.subtype
  case "2d"
     prtcoor = @(id, coor) fprintf(fid, "%d %-f %f 0.0\n", id, coor);
  case "3d"
     prtcoor = @(id, coor) fprintf(fid, "%d %f %f %f\n", id, coor);
  end

# Nodal point data

  fprintf(fid, "$Nodes\n");

  nofnod = cmp.nodes.nofnod;
  fprintf(fid, "%d\n", nofnod);

  for n = 1 : nofnod
      prtcoor(cmp.nodes.ids(n), cmp.nodes.coor(n, :));
  end

  fprintf(fid, "$EndNodes\n");

# Element data

  fprintf(fid, "$Elements\n");

  nofelt = cmp.elements.nofelt;
  fprintf(fid, "%d\n", nofelt);

  noftag = 2;
  tags   = [ 1, 1];   % Dummy tags

  for ntype = 1 : cmp.elements.noftyp

      gmshtype = cmp.elements.types(ntype).gmshid;
      nelnod   = cmp.elements.types(ntype).nelnod;

      m1 = cmp.elements.types(ntype).ixelt1;
      m2 = m1 + cmp.elements.types(ntype).nofelt - 1;

      for m = m1 : m2
          fprintf(fid, "%d %d %d %d %d", ...
                  cmp.elements.elem(m).id, gmshtype, noftag, tags);
          for k = 1 : nelnod
              nodid = cmp.nodes.ids(cmp.elements.elem(m).nodes(k));
              fprintf(fid, " %d", nodid);
          end
          fprintf(fid, "\n");
      end 

  end     % Loop over element types
  
  fprintf(fid, "$EndElements\n");

end
