function mfs_exp_tdisp(fid, cmp, disp, t, title)

# usage: mfs_exp_tdisp(fid, cmp, disp, t, title)
#
# Input  fid         File handle of output file
#        cmp         Structure with component
#        disp(:, :)  Displacements
#        t(:)        Time steps
#        title       View name
#
# The function exports time-dependent displacements in Gmsh MSH file
# format.
#
# ------------------------------------------------------------------------

  zero = 0.;

# Get parameters needed

  nofnod   = cmp.nodes.nofnod;
  ncoor    = cmp.nodes.ncoor;
  mxdofpnt = cmp.dofs.mxdofpnt;
  [m, nt] = size(disp);

# Define function to write the displacements

  if (ncoor == 2)
     prt = @(id, u) fprintf(fid, "%-5d %-10.3e %-10.3e 0.0\n", id, u);
  else
     prt = @(id, u) fprintf(fid, "%-5d %-10.3e %-10.3e %-10.3e\n", id, u);
  end

# Number of rotational dofs per node (to be skipped)

  nrdof = mxdofpnt - ncoor;

# Loop over time steps

  for l = 1 : nt

#     Header

      fprintf(fid, "$NodeData\n");

#     Tags

      fprintf(fid, "1\n""%s""\n", title);
      fprintf(fid, "1\n%-10.3e\n", t(l));
      fprintf(fid, "3\n%-3d\n3\n%-5d\n", l - 1, nofnod);

#     Data

      dof = 0;
      for n = 1 : nofnod
          id = cmp.nodes.ids(n);
          for k = 1 : ncoor
              u(k) = disp(++dof, l);
          end
          prt(id, u);
          dof += nrdof;
      end

#     End

      fprintf(fid, "$EndNodeData\n");

  end   % Timestep loop

end
